

local _l_track_id = ac.getTrackID()
local _l_track_layout = ac.getTrackLayout()
local _l_tracks_config_custom_path = ac.getFolder(ac.FolderID.ExtRoot).."\\config-ext\\Pure\\custom_track_adaptions\\groundfog"
local _l_tracks_extension_path = ac.getFolder(ac.FolderID.ContentTracks).."\\".._l_track_id.."\\extension\\Pure"
local _l_pure_track_adpations_path = ac.dirname().."\\..\\..\\..\\extension\\weather\\pure\\track_adaptions\\groundfog"

local _l_custom_user_file   = _l_tracks_config_custom_path.."\\groundfog_".._l_track_id.."_".._l_track_layout..".json"
local _l_track_ext_file     = _l_tracks_extension_path.."\\groundfog_".._l_track_layout..".json"
local _l_pure_track_file    = _l_pure_track_adpations_path.."\\groundfog_".._l_track_id.."_".._l_track_layout..".json"
local _l_pure_tmp_file      = _l_pure_track_adpations_path.."\\groundfog_tmp.json"

local _l_loaded_file = ""

local _l_files_exist = {
    custom = false,
    track = false,
    pure = false
}
local function check_files_exist()
    _l_files_exist.custom = file_exists(_l_custom_user_file)
    _l_files_exist.track = file_exists(_l_track_ext_file)
    _l_files_exist.pure = file_exists(_l_pure_track_file)
end

local fileDialog = PureUI_FileDialog(_l_tracks_config_custom_path)
fileDialog:addFavoriteFolder("User dir", _l_tracks_config_custom_path)
fileDialog:addFavoriteFolder("Track dir", _l_tracks_extension_path)
fileDialog:addFavoriteFolder("Pure dir", _l_pure_track_adpations_path)
fileDialog:initFileDialog(_l_tracks_config_custom_path, "json", "Import Groundfog adaption")




local _l_spline = ac.hasTrackSpline()


local tmp_vec2 = vec2(0,0)
--local tmp_vec3 = vec3(-2085, 79, 1003)
local tmp_vec3 = vec3(0, 0, 0)
local tmp_vec3_2 = vec3(0, 0, 0)

local _l_track_progress_scale = 0.1
local _l_spline_points = 1000
local _l_spline_scale = 0.01
local _l_spline_table = {}

local _l_track_mod = {}
local _l_TrackModCPP = nil 

local _l_updated_spline_count = 0
local _l_update_spline_table = {}

local tmp_cam_pos = vec3(0,0,0)
local tmp_cam_dir = vec3(0,0,0)
local tmp_vec_sub = vec3(0,0,0)


local _l_target_size = nil
local _l_target_ratio = 1.0


local function check_target_size(new_size, screenshot)
    _l_target_size = new_size or render.getRenderTargetSize()
    _l_target_ratio = _l_target_size.y>0 and _l_target_size.x / _l_target_size.y or 1.00
end
check_target_size()
ac.onResolutionChange(check_target_size)

local _l_mouse_dragging = false





local function groundfog_init_spline()

    tmp_vec3:set(ac.trackProgressToWorldCoordinate(0))

    local l = #(tmp_vec3-ac.trackProgressToWorldCoordinate(0.01))
    _l_spline_scale = _l_track_progress_scale / l
    _l_spline_points = math.floor(1/_l_spline_scale)

    local progress = 0

    for i=1, _l_spline_points do
        progress = i/_l_spline_points
        ac.trackProgressToWorldCoordinateTo(i/_l_spline_points, tmp_vec3)
        table.insert(_l_spline_table, { position = vec3():set(tmp_vec3),
                                        offset = 0,
                                        distance = 100000,
                                        progress = progress,
                                        cue = -1,
                                })
    end
end











local function groundfog_init_trackmod()

    _l_track_mod = {}
    
    table.insert(_l_track_mod, { 0, 1, 0 })
    table.insert(_l_track_mod, { 1, _l_spline_points, 0 })

    _l_TrackModCPP = LUT:new(_l_track_mod)
end

local function groundfog_update_trackmod()
    for i=1, _l_spline_points do
        _l_spline_table[i].offset = _l_TrackModCPP:get(_l_spline_table[i].progress)[2] -- index is excluded !!!
    end
end

local function groundfog_reinit_trackmod_LUT()
    -- reinit all indices to the spline

    for i=1, _l_spline_points do
        _l_spline_table[i].cue = -1
    end

    for i=2, #_l_track_mod-1 do
        local progress_quant = math.floor( _l_track_mod[i][1] * _l_spline_points) / _l_spline_points
        local spline_index = math.floor(progress_quant * _l_spline_points) + 1
        if spline_index < _l_spline_points then
            _l_spline_table[spline_index].cue = i
        end
    end

    _l_spline_table[1].cue = 1
    _l_spline_table[#_l_spline_table].cue = #_l_track_mod

    _l_TrackModCPP = LUT:new(_l_track_mod)
    -- update the interpolation
    groundfog_update_trackmod()
end

local function groundfog_reinit_trackmod_LUT_values()
    _l_TrackModCPP:generate()
    groundfog_update_trackmod()
end









local function save_data(file)

    if file and file~="" then
        local export_data = {}
        for i=1, #_l_track_mod do
            ac.trackProgressToWorldCoordinateTo(_l_track_mod[i][1], tmp_vec3)
            export_data[i] = {
                point_index = i,
                spline_index = _l_track_mod[i][2],
                progress = _l_track_mod[i][1],
                offset = _l_track_mod[i][3],
                coord_x = tmp_vec3.x,
                coord_y = tmp_vec3.y,
                coord_z = tmp_vec3.z,
            }
        end
        
        local buffer = json.encode(export_data)
        if buffer then
            if not file_write(file, buffer) then
                ac.debug("Can't save file", file)
            else
            end
        else
            ac.debug("Can't encode json", "Save Groundfog file")
        end
    end

    check_files_exist()
end

local function save_track(bOverwrite)
    if bOverwrite then
        save_data(_l_track_ext_file)
    end
end
local function save_pure(bOverwrite)
    if bOverwrite then
        save_data(_l_pure_track_file)
    end
end

local function save_tmp()
    save_data(_l_pure_tmp_file)
end

local _l_file_loaded_color = rgbm(0,0,0,0)
local function load_data(file, loaded, color)
    if file and file~="" then
        local buffer = io.load(file, nil)
        if buffer and #buffer>2 then
            local tmp = json.decode(buffer)
            if tmp and #tmp>0 then

                local tmp_list = {}
                for i, p in ipairs(tmp) do
                    if p.point_index~=nil and p.spline_index~=nil and p.progress~=nil and p.offset~=nil then
                        tmp_list[p.point_index] = {}
                        tmp_list[p.point_index][1] = p.progress
                        tmp_list[p.point_index][2] = p.spline_index
                        tmp_list[p.point_index][3] = math.floor(p.offset * 100) * 0.01
                    end
                end

                _l_track_mod = {}
                table.insert(_l_track_mod, { 0, 1, tmp_list[1][3] })
                for i=2, #tmp_list-1 do
                    if tmp_list[i]~=nil then
                        table.insert(_l_track_mod, { tmp_list[i][1], math.floor(tmp_list[i][1]*_l_spline_points), tmp_list[i][3] })
                    end
                end
                table.insert(_l_track_mod, { 1, _l_spline_points, tmp_list[#tmp_list][3] })
                -- check the table's sorting
                table.sort(_l_track_mod, function(a,b) return a[1] < b[1] end )

                groundfog_reinit_trackmod_LUT()
                groundfog_update_trackmod()

                _l_loaded_file = loaded
                _l_file_loaded_color:set(color)

                save_tmp()

                return true
            else
                ac.debug("Can't decode json", "Load Groundfog file")
            end
        else
            --ac.debug("Can't open file", file)
        end
    else
        --ac.debug("Load Groundfog file", "File does not exist: "..file.." !")
    end

    return false
end

local function load_user()
    return load_data(_l_custom_user_file, "loaded file: Custom user -> ".."groundfog_".._l_track_id.."_".._l_track_layout..".json", rgbm.colors.yellow)
end
local function load_track()
    return load_data(_l_track_ext_file, "loaded file: Track extension -> ".."groundfog_".._l_track_layout..".json", rgbm.colors.cyan)
end
local function load_pure()
    return load_data(_l_pure_track_file, "loaded file: Pure track adaption -> ".."groundfog_".._l_track_id.."_".._l_track_layout..".json", rgbm.colors.orange)
end


local function import_data(file)

    if file and file~="" then
        local buffer = io.load(file, nil)
        if buffer and #buffer>2 then
            local tmp = json.decode(buffer)
            if tmp and #tmp>0 then

                local tmp_list = {}
                for i, p in ipairs(tmp) do
                    if p.point_index~=nil and p.spline_index~=nil and p.progress~=nil and p.offset~=nil then
                        tmp_list[p.point_index] = {}
                        tmp_list[p.point_index][1] = p.progress
                        tmp_list[p.point_index][2] = p.spline_index
                        tmp_list[p.point_index][3] = math.floor(p.offset * 100) * 0.01
                        tmp_list[p.point_index][4] = p.coord_x
                        tmp_list[p.point_index][5] = p.coord_y
                        tmp_list[p.point_index][6] = p.coord_z
                    end
                end

                _l_track_mod = {}

                table.insert(_l_track_mod, { 0, 1, tmp_list[1][3] })
                -- read it backwards, so back and forth traffic splines will have the 1st half as priority
                for i=#tmp_list-1, 2, -1 do
                    if tmp_list[i]~=nil then
                        tmp_vec3:set(tmp_list[i][4], tmp_list[i][5], tmp_list[i][6])
                        local progress = math.saturateN(ac.worldCoordinateToTrackProgress(tmp_vec3))
                        ac.trackProgressToWorldCoordinateTo(progress, tmp_vec3_2)
                        tmp_vec3_2:sub(tmp_vec3)
                        if #tmp_vec3_2 < 5 then
                            local found = false
                            for ii=1, i-1 do
                                if progress == tmp_list[ii][1] then
                                    tmp_list[ii][3] = tmp_list[i][3]
                                    found = true
                                    break
                                end
                            end
                            if not found then
                                table.insert(_l_track_mod, { progress, math.floor(progress*_l_spline_points), tmp_list[i][3] })
                            end
                        end
                    end
                end
                table.insert(_l_track_mod, { 1, _l_spline_points, tmp_list[#tmp_list][3] })

                -- check the table's sorting
                table.sort(_l_track_mod, function(a,b) return a[1] < b[1] end )

                groundfog_reinit_trackmod_LUT()
                groundfog_update_trackmod()

                _l_loaded_file = #_l_track_mod.." Points succsessfully imported."
                _l_file_loaded_color:set(rgbm.colors.lime)

                save_tmp()

                return true
            else
                ac.debug("Can't decode json", "Load Groundfog file")
            end
        else
            --ac.debug("Can't open file", file)
        end
    else
        --ac.debug("Load Groundfog file", "File does not exist: "..file.." !")
    end

    return false
end


local function remove_file(file)
    if file_exists(file) then
        os.remove(file)
    end
    check_files_exist()
end

local function remove_user_file(bDelete)
    if bDelete then
        remove_file(_l_custom_user_file)
    end
end


local function remove_all_points(bDelete)
    if bDelete then
        groundfog_init_trackmod()
        groundfog_reinit_trackmod_LUT()
        save_tmp()
    end
end


local function groundfog_remove_trackmod_point(index)

    if #_l_track_mod < 3 then 
        return
    end

    if _l_track_mod[index]~=nil then
        local sline_index = _l_track_mod[index][2]
        if sline_index>0 then
            -- remove the cue from the spline
            _l_spline_table[sline_index].cue = -1
        end
        -- remove the point
        table.remove(_l_track_mod, index)
        groundfog_reinit_trackmod_LUT()
    end
end

local function groundfog_add_trackmod_point(spline_index, insert)

    if spline_index<=1 or spline_index>=_l_spline_points then
        return
    end

    if _l_spline_table[spline_index]~=nil then
        
        -- try to interpolate the new value from the already exisiting point before and after it.
        local before = math.max(1, insert-1)
        local a = 0
        if _l_track_mod[before]~=nil then
            a = _l_track_mod[before][3] 
        end
        local after = math.max(1, insert)
        local b = a
        if _l_track_mod[after]~=nil then
            b = _l_track_mod[after][3] 
        end

        -- insert the point
        table.insert(_l_track_mod, insert, { _l_spline_table[spline_index].progress - 0.0001, spline_index, (a+b)*0.5 })
        groundfog_reinit_trackmod_LUT()
    end
end




if ac.hasTrackSpline() then
    groundfog_init_spline()
    groundfog_init_trackmod()
    groundfog_reinit_trackmod_LUT()

    check_files_exist()

    -- try to load track adaptions data
    if not load_user() then
        if not load_track() then
            load_pure()
        end
    end
end




local tmp_rgbm = rgbm(25,0,0,1)
local tmp_rgbm2 = rgbm(0,25,0,1)
local rgbm_selected = rgbm(0,50,0,1)
local mouse_tmp_vec2 = vec2(0,0)
local _l_minimum_mouse_distance = 100
--local _l_scene_dis = 1000000
--local _l_scene_dist_update = 0
--local _l_ray = nil
local mouse_dist = { distance = 10000000, index = -1, last_index = -1, changed = false }

local _l_mouse_pos = vec2()
local function update_mouse_position()
    local acui = ac.getUI()
    _l_mouse_pos:set(ui.mousePos())
    _l_mouse_pos.x = _l_mouse_pos.x / _l_target_size.x * acui.uiScale
    _l_mouse_pos.y = _l_mouse_pos.y / _l_target_size.y * acui.uiScale
end

local function check_mouse_hover(prpo)
    mouse_tmp_vec2:set(_l_mouse_pos)
    mouse_tmp_vec2:sub(prpo)
    mouse_tmp_vec2.x = mouse_tmp_vec2.x * 2000 * _l_target_ratio
    mouse_tmp_vec2.y = mouse_tmp_vec2.y * 2000
    return #mouse_tmp_vec2
end

function Update_groundfog_graphics(dt)

    local fov_mod = 60/ac.getCameraFOV()
    local point_mouse_hover = not ui.isMouseDragging(ui.MouseButton.Left) and not ui.mouseDown(ui.MouseButton.Right) and not PureConfig_mouse_is_on_app()

    local point_visible = false
    local last_point_visible = false
    local last_progress = -1
    local last_point_index = -1
    local minimum_progress_distance = 5/_l_spline_points

    update_mouse_position()

    if _l_updated_spline_count > 0 then

        local index = _l_update_spline_table[1]

        if point_mouse_hover then
            mouse_dist.distance     = 10000000
            mouse_dist.last_index   = mouse_dist.index
            mouse_dist.index        = -1
        end

        tmp_vec3:set(_l_spline_table[index].position)
        local prpo = render.projectPoint(_l_spline_table[index].position)
        last_point_visible = (prpo.x > 0 and prpo.x < 1 and prpo.y > 0 and prpo.y < 1)
        last_progress = _l_spline_table[index].progress
            
        if last_point_visible then
            if point_mouse_hover then
                mouse_dist.distance = check_mouse_hover(prpo)
                if mouse_dist.distance < _l_minimum_mouse_distance then
                    mouse_dist.index = index
                end
            end
            if _l_spline_table[index].cue > 0 then
                render.debugPoint(_l_spline_table[index].position, (250/_l_spline_table[index].distance)*fov_mod, tmp_rgbm)
            end
            last_point_index = index
        end

        for i=2, _l_updated_spline_count do
            index = _l_update_spline_table[i]

            local offset = 0
            if _l_spline_table[index].offset > 0 then
                offset = 0.5+_l_spline_table[index].offset*0.25
                tmp_rgbm.r = 5 + 50*offset^3
                tmp_rgbm.g = 5 - 5*offset
                tmp_rgbm.b = 5 - 5*offset
                tmp_rgbm.mult = 1
            else
                offset = 0.5-_l_spline_table[index].offset*0.25
                tmp_rgbm.r = 5 - 5*offset
                tmp_rgbm.g = 5 - 5*offset
                tmp_rgbm.b = 5 + 50*offset^3
                tmp_rgbm.mult = 1
            end
            

            prpo = render.projectPoint(_l_spline_table[index].position)
            point_visible = (prpo.x > 0 and prpo.x < 1 and prpo.y > 0 and prpo.y < 1)

            if  (point_visible or last_point_visible) and 
                math.abs(last_progress-_l_spline_table[index].progress) < minimum_progress_distance then
                render.debugLine(tmp_vec3, _l_spline_table[index].position, tmp_rgbm)
            end

            if point_visible  then

                --render.debugText(_l_spline_table[index].position, _l_spline_table[index].cue, tmp_rgbm, 2)

                if _l_spline_table[index].cue > 0 then
                    render.debugPoint(_l_spline_table[index].position, (250/_l_spline_table[index].distance)*fov_mod, tmp_rgbm)
                end

                if point_mouse_hover then
                    local d = check_mouse_hover(prpo) --math.abs((scene_hit and _l_scene_dis or _l_ray:distance(tmp_vec3)) - _l_spline_table[index].distance)
                    if d < _l_minimum_mouse_distance and d < mouse_dist.distance then
                        mouse_dist.distance = d
                        mouse_dist.index = index
                    end
                end

                last_point_index = index
            end

            last_point_visible = point_visible
            last_progress = _l_spline_table[index].progress
            tmp_vec3:set(_l_spline_table[index].position)
        end

        if mouse_dist.index > 0 then
            render.debugCross(_l_spline_table[mouse_dist.index].position, 2, tmp_rgbm2)
        end

        if mouse_dist.index ~= mouse_dist.last_index then
            mouse_dist.changed = true
        end

        if mouse_dist.index > 0 and _l_spline_table[mouse_dist.index].cue > 0 then
            render.debugPoint(_l_spline_table[mouse_dist.index].position, (300/_l_spline_table[mouse_dist.index].distance)*fov_mod, rgbm_selected)
        end
    end
end





local function rotate2d(p, theta)

	local a = _toRadians(theta)
    local c = math.cos(a);
    local s = math.sin(a);

	local x = p.x
	local y = p.y

	p.x = c*x - s*y
	p.y = s*x + c*y

	return p
end




function Update_groundfog_spline_distances(dt)
    --if subscribed then
        tmp_cam_pos:set(ac.getCameraPosition())
        ac.getCameraDirectionTo(tmp_cam_dir)
        local min_dist = 750
        local n = 0
        local dist
        local count = #_l_spline_table
        -- go through the table in rough steps to minimize the access
        -- if a billboard is in the minimum range, calculate the distance of the neighbours
        -- And add the index of the billboards within the render distance to the updated list.
        
        for i=6, count, 10 do
            tmp_vec_sub:set(_l_spline_table[i].position)
            tmp_vec_sub:sub(tmp_cam_pos)
            dist = #tmp_vec_sub
            if dist <= min_dist then
                for ii=i-5, i+4 do
                    if ii<=count then
                        tmp_vec_sub:set(_l_spline_table[ii].position)
                        tmp_vec_sub:sub(tmp_cam_pos)
                        _l_spline_table[ii].distance = #tmp_vec_sub
                        n=n+1
                        _l_update_spline_table[n] = ii
                    end
                end
            end
        end
        
        _l_updated_spline_count = n
    --end
end








function customfunc_groundfog_init(custom)

    if custom and _l_spline then

        --local _l_path = ac.getFolder(ac.FolderID.ExtRoot).."\\weather\\pure\\render\\landscape\\textures\\"
        --custom.files = {}

        --io.scanDir(_l_path, "*.dds", function(name, attrib)
        --    if not attrib.isDirectory then
        --        name = name:gsub("%.dds", "")
        --        table.insert(custom.files, name)
        --    end
        --end)

        custom.h = 500

        --custom.selected = ""
        
    end
end












-- UI






local _l_list_current_first = 1
local _l_list_entry_height = 20
local list_color_selected = rgbm(0,1.0,0,0.2)
local list_color_selected_before = rgbm(0,1.0,0,0.5)
local selected = -1
local before = false
local LR__tmp_vec1 = vec2(0,0)
local LR__tmp_vec2 = vec2(0,0)
local LR__tmp_vec3 = vec3(0,0,0)
local function list_render()
    local y = 0
    local scrollpos = ui.getScrollY()
    local x = ui.getCursorX()
    
    if mouse_dist.changed and mouse_dist.index>0 then
        mouse_dist.changed = false

        if _l_spline_table[mouse_dist.index].cue > 0 then
            selected = _l_spline_table[mouse_dist.index].cue
            before = false
        else
            before = true
            local n = mouse_dist.index
            repeat
                n=n+1
                if n<=_l_spline_points then
                    selected = _l_spline_table[n].cue
                end
            until n>(_l_spline_points-1) or selected>0
            if selected<1 then
                selected = #_l_track_mod
            end
        end
        
        scrollpos = math.max(0, selected - 5) * _l_list_entry_height
        ui.setScrollY(scrollpos, false, false)
    else
        if mouse_dist.index<1 then
            selected = -1
            before = false
        end
    end

    _l_list_current_first = math.floor(scrollpos / _l_list_entry_height) + 1
    for i=_l_list_current_first, math.min(#_l_track_mod, _l_list_current_first+10) do

        y = (i-1)*_l_list_entry_height

        if i==selected then
            if not before then
                UI_gl_rect_filled(0, y, ui.availableSpaceX()-15, y+_l_list_entry_height-2, list_color_selected)
            else
                UI_gl_rect_filled(0, y-1, ui.availableSpaceX()-15, y+1, list_color_selected_before)
            end
        end

        
        LR__tmp_vec1.x = x
        LR__tmp_vec1.y = y
        LR__tmp_vec2.x = LR__tmp_vec1.x + 39
        LR__tmp_vec2.y = LR__tmp_vec1.y + 19
        if ui.rectHovered(LR__tmp_vec1, LR__tmp_vec2) then
            UI_gl_rect_filled(LR__tmp_vec1.x, LR__tmp_vec1.y, LR__tmp_vec2.x, LR__tmp_vec2.y, rgbm.colors.green)
            if ui.mouseClicked(ui.MouseButton.Left) then
                local spline_pos = _l_track_mod[i][2] - 15
                if spline_pos < 1 then
                    spline_pos = spline_pos + _l_spline_points
                end
                LR__tmp_vec3:set(_l_spline_table[spline_pos].position)
                LR__tmp_vec3.y = LR__tmp_vec3.y + 75
                ac.setCameraPosition(LR__tmp_vec3)

                LR__tmp_vec3:sub(_l_spline_table[_l_track_mod[i][2]].position)
                LR__tmp_vec3:normalize()
                ac.setCameraDirection(-LR__tmp_vec3)

                ac.setCameraFOV(60)
            end  
        end

        ui.setCursorX(5)
        ui.setCursorY(y)
        ui.pushStyleColor(ui.StyleColor.Text, rgbm.colors.white)
        ui.text(i)
        ui.popStyleColor(1)

        ui.setCursorX(45)
        ui.setCursorY(y)
        
        local offset = 0
        if _l_track_mod[i][3] > 0 then
            offset = _l_track_mod[i][3]*0.5
            tmp_rgbm.r = 0.75 + 0.5*offset
            tmp_rgbm.g = 0.75 - 0.5*offset
            tmp_rgbm.b = 0.75 - 0.5*offset
            tmp_rgbm.mult = 1
        else
            offset = -_l_track_mod[i][3]*0.5
            tmp_rgbm.r = 0.75 - 0.25*offset
            tmp_rgbm.g = 0.75 - 0.25*offset
            tmp_rgbm.b = 0.75 + 1.5*offset
            tmp_rgbm.mult = 1
        end
        ui.pushStyleColor(ui.StyleColor.Text, tmp_rgbm)
        ui.text(_l_track_mod[i][3])
        ui.popStyleColor(1)
    end
end


local function FileDialogRender()
    fileDialog:FileDialog()
end

local _l_list_size = vec2(300,200)
local _l_button_size = vec2(0,0)
local _l_button_color = rgbm(0.4, 0.4, 0.4, 1.0)
local _l_button_remove_color = rgbm(0.50, 0.15, 0.15, 1.0)
local _l_button_import_color = rgbm(0.15, 0.40, 0.15, 1.0)
local _l_complete_list_size = vec2(0,0)
local _l_last_dragging_delta = vec2(0,0)
local _l_dragging_origin_value = vec2(0,0)
function customfunc_groundfog_render(custom)

    if custom and not custom.hidden and _l_spline then

        if fileDialog.running then
            _l_list_size:set(ui.availableSpaceX(), custom.h)
            ui.setNextWindowContentSize(_l_list_size)
            ui.childWindow("PureConfig_GROUNDFOG_render_list", _l_list_size, FileDialogRender)
            --fileDialog:FileDialog()
        else

            local x = ui.getCursorX()
            local y = ui.getCursorY()

            if not PureConfig_mouse_is_on_app() then
                
                if ui.mouseClicked(ui.MouseButton.Left) then
                    if mouse_dist.index > 0 and selected>0 then
                        if before then
                            -- a sline point but not a trackmod point is selected
                            groundfog_add_trackmod_point(mouse_dist.index, selected)
                            mouse_dist.changed = true

                            save_tmp()
                        else
                            -- a trackmod point is selected
                        end
                    end
                end

                if ui.mouseDoubleClicked(ui.MouseButton.Left) then
                    if selected > 0 and not before then
                        -- a trackmod point is selected
                        groundfog_remove_trackmod_point(selected)
                        mouse_dist.changed = true

                        save_tmp()
                    end
                end

                if ui.mouseClicked(ui.MouseButton.Right) then
                    if selected > 0 and not before then
                        -- a trackmod point is selected
                        _l_track_mod[selected][3] = 0
                        groundfog_reinit_trackmod_LUT_values()

                        save_tmp()
                    end
                end

                if ui.mouseReleased(ui.MouseButton.Left) and _l_mouse_dragging then
                    save_tmp()
                end

                if ui.isMouseDragging(ui.MouseButton.Left) then
                    local delta = ui.mouseDragDelta(ui.MouseButton.Left)
                    if selected > 0 and not before then

                        if not _l_mouse_dragging then
                            _l_dragging_origin_value.y = _l_track_mod[selected][3]
                        end

                        _l_mouse_dragging = true
                        
                        -- a trackmod point is selected
                        if _l_last_dragging_delta.y~=delta.y then
                            -- fog offset
                            _l_track_mod[selected][3] = math.clampN(_l_dragging_origin_value.y - 0.0125*delta.y, -2, 2)
                            _l_track_mod[selected][3] = math.floor(_l_track_mod[selected][3]*100)*0.01
                            groundfog_reinit_trackmod_LUT_values()
                        end
                    end
                    _l_last_dragging_delta:set(delta)
                else
                    _l_mouse_dragging = false
                end

                
            end

            if _l_loaded_file~="" then
                ui.setCursorY(y)
                ui.setCursorX(x)
                ui.pushStyleColor(ui.StyleColor.Text, _l_file_loaded_color)
                ui.text(_l_loaded_file)
                ui.popStyleColor(1)
                y = y+20
            end

            ui.setCursorY(y)
            ui.setCursorX(x)
            ui.pushStyleColor(ui.StyleColor.Text, rgbm.colors.gray)
            ui.text("Mouse Left: singleclick = add point | doubleclick = remove point")
            ui.text("Mouse Left: hold+drag = set value (-2..2)")
            ui.text("Mouse Right: singleclick = reset value to 0")
            ui.popStyleColor(1)

            y = y + 65
            ui.setCursorY(y)
            ui.setCursorX(x + 5)
            _l_list_size:set(150, 200)
            _l_complete_list_size:set(_l_list_size.x, #_l_track_mod*_l_list_entry_height)
            ui.setNextWindowContentSize(_l_complete_list_size)
            ui.childWindow("PureConfig_GROUNDFOG_render_list", _l_list_size, list_render)

            UI_gl_rect(x,y-6,x+_l_list_size.x+10,y-6+_l_list_size.y+10,rgbm.colors.white,1)

            y = y +_l_list_size.y + 10
            UI_gl_rect_filled(x,y,x+ui.availableSpaceX(),y+2,rgbm.colors.gray)

            local y_save_load = y

            y = y - 60

            ui.setCursorX(x + 170)
            ui.setCursorY(y)
            _l_button_size:set(170, 25)
            ui.pushStyleColor(ui.StyleColor.Button, _l_button_remove_color)
            ui.pushStyleColor(ui.StyleColor.Text, rgbm.colors.white)
            if ui.button("remove all points", _l_button_size) then
                fileDialog:startConfirmDialog(remove_all_points, "Remove all points?")
            end
            ui.popStyleColor(2)

            y = y + 30

            ui.pushStyleColor(ui.StyleColor.Button, _l_button_import_color)
            ui.pushStyleColor(ui.StyleColor.Text, rgbm.colors.white)
            ui.setCursorX(x + 170)
            ui.setCursorY(y)
            _l_button_size:set(170, 25)
            if ui.button("import", _l_button_size) then
                fileDialog:startFileDialog(import_data, "Import Groundfog Adaption file", nil, "json")
            end
            ui.popStyleColor(2)



            ui.pushStyleColor(ui.StyleColor.Button, _l_button_color)

            y = y_save_load + 7


            UI_gl_rect_filled(x,y,x+5,y+25,rgbm.colors.yellow)
            ui.setCursorX(x + 10)
            ui.setCursorY(y)
            _l_button_size:set(150, 25)
            if ui.button("SAVE user custom", _l_button_size) then
                save_data(_l_custom_user_file)
            end

            if _l_files_exist.custom then
                ui.setCursorX(x + 170)
                ui.setCursorY(y)
                _l_button_size:set(150, 25)
                if ui.button("LOAD user custom", _l_button_size) then
                    load_user()
                end

                ui.setCursorX(x + 330)
                ui.setCursorY(y)
                _l_button_size:set(25, 25)
                ui.pushStyleColor(ui.StyleColor.Button, rgbm.colors.maroon)
                if ui.iconButton(ui.Icons.Delete, _l_button_size, rgbm.colors.white) then
                    fileDialog:startConfirmDialog(remove_user_file, "Delete the user groundfog adaption?")
                end
                ui.popStyleColor(1)
            end

            y = y + 30

            UI_gl_rect_filled(x,y,x+5,y+25,rgbm.colors.cyan)
            ui.setCursorX(x + 10)
            ui.setCursorY(y)
            _l_button_size:set(150, 25)
            if ui.button("SAVE track extension", _l_button_size) then
                if file_exists(_l_track_ext_file) then
                    fileDialog:startConfirmDialog(save_track, "Overwrite the track's adaption file?")
                else
                    save_track(true)
                end
            end

            if _l_files_exist.track then
                ui.setCursorX(x + 170)
                ui.setCursorY(y)
                _l_button_size:set(150, 25)
                if ui.button("LOAD track extension", _l_button_size) then
                    load_track()
                end
            end

            y = y + 30

            UI_gl_rect_filled(x,y,x+5,y+25,rgbm.colors.orange)
            ui.setCursorX(x + 10)
            ui.setCursorY(y)
            _l_button_size:set(150, 25)
            if ui.button("SAVE Pure default", _l_button_size) then
                if file_exists(_l_pure_track_file) then
                    fileDialog:startConfirmDialog(save_pure, "Overwrite Pure's default adaption file?")
                else
                    save_pure(true)
                end
            end

            if _l_files_exist.pure then
                ui.setCursorX(x + 170)
                ui.setCursorY(y)
                _l_button_size:set(150, 25)
                if ui.button("LOAD Pure default", _l_button_size) then
                    load_pure()
                end
            end

            ui.popStyleColor(1)


            

            
        end   
    end

    return nil
end